<?php
namespace Aepro\Modules\Trigger\Skins;

use Aepro\Aepro;
use Aepro\Base\Widget_Base;
use Elementor\Controls_Manager;
use Aepro\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_Style1 extends Skin_Base {
	//phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore
	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action('elementor/element/ae-trigger/style1_section_style_trigger/before_section_end', [ $this, 'update_style_controls' ] );
	}

	public function get_id() {
		return 'style1';
	}

	public function get_title() {
		return __( 'Style 1', 'ae-pro' );
	}

	public function register_controls( Widget_Base $widget ) {

		$this->parent = $widget;

	}

	public function update_style_controls(){
		$this->update_control(
			'border_border',
			[
				'default' => 'solid',
			]
		);

		$this->update_control(
			'border_width',
			[
				'default' => [
					'top'    => '2',
					'right'  => '2',
					'bottom' => '2',
					'left'   => '2',
				],
			]
		);

		$this->update_control(
			'border_color',
			[
				'default' => '#F4A8A3',
			]
		);

		$this->update_control(
			'border_radius',
			[
				'default' => [
					'top'    => '5',
					'right'  => '5',
					'bottom' => '5',
					'left'   => '5',
				],
			]
		);

		$this->update_control(
			'padding',
			[
				'default' => [
					'top'    => '5',
					'right'  => '5',
					'bottom' => '5',
					'left'   => '5',
				],
			]
		);

		$this->update_control(
			'trigger_text_color',
			[
				'default' => '#F4A8A3',
			]
		);

		$this->update_control(
			'trigger_background_background',
			[
				'default' => 'classic'
			]
		);

		$this->update_control(
			'trigger_background_color',
			[
				'default' => '#FFFFFF00'
			]
		);

		$this->update_control(
			'trigger_text_color',
			[
				'default' => '#F4A8A3'
			]	
		);

		$this->update_control(
			'trigger_border_border',
			[
				'default' => 'solid',
			]
		);

		$this->update_control(
			'trigger_border_width',
			[
				'default' => [
					'top'    => '2',
					'right'  => '2',
					'bottom' => '2',
					'left'   => '2',
				],
			]
		);

		$this->update_control(
			'trigger_border_color',
			[
				'default' => '#FFFFFF00',
			]
		);

		$this->update_control(
			'trigger_border_radius',
			[
				'default' => [
					'top'    => '5',
					'right'  => '5',
					'bottom' => '5',
					'left'   => '5',
				],
			]
		);

		$this->update_control(
			'trigger_hover_border_color',
			[
				'default' => '#F4A8A3',
			]
		);

	}
    
    public function render() {
		$settings = $this->parent->get_settings_for_display();
		parent::render_trigger();
	}
}