<?php
namespace Aepro\Modules\Trigger\Skins;

use Aepro\Aepro;
use Aepro\Base\Widget_Base;
use Elementor\Controls_Manager;
use Aepro\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_Style2 extends Skin_Base {
	//phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore
	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
        add_action('elementor/element/ae-trigger/style2_section_style_trigger/before_section_end', [ $this, 'update_style_controls' ] );
	}

	public function get_id() {
		return 'style2';
	}

	public function get_title() {
		return __( 'Style 2', 'ae-pro' );
	}

	public function register_controls( Widget_Base $widget ) {

		$this->parent = $widget;

	}

	public function update_style_controls(){

		$this->update_control(
			'trigger_background_background',
			[
				'default' => 'classic'
			]
		);

		$this->update_control(
			'trigger_background_color',
			[
				'default' => '#FFFFFF00'
			]
		);

		$this->update_control(
			'trigger_text_color',
			[
				'default' => '#4054B2'
			]	
		);

		$this->update_control(
			'trigger_border_border',
			[
				'default' => 'solid',
			]
		);

		$this->parent->update_control(
			$this->get_control_id('trigger_border_width'),
			[
				'default' => [
					'top'    => '2',
					'right'  => '2',
					'bottom' => '2',
					'left'   => '2',
				],
			]
		);

		$this->update_control(
			'trigger_border_radius',
			[
				'default' => [
					'top'    => '50',
					'right'  => '50',
					'bottom' => '50',
					'left'   => '50',
					'unit'	=> '%'
				],
			]
		);

		$this->update_control(
			'trigger_border_color',
			[
				'default' => '#4054B2',
			]
		);

		$this->update_control(
			'item_spacing',
			[
				'default' => [
					'size' => 10,
				],
			]
		);

		$this->update_responsive_control(
			'trigger_text_padding',
			[
				'default' => [
					'top'    => '12',
					'right'  => '12',
					'bottom' => '12',
					'left'   => '12',
				],
			]
		);
	}
    
    public function render() {
		$settings = $this->parent->get_settings_for_display();
		parent::render_trigger();
	}
}