<?php
/*
Plugin Name: Freesoul Responsive Check
Description: It adds a tool in the Customize preview to check the responsiveness of your WordPress website.
Author: Jose Mortellaro
Author URI: https://josemortellaro.com/
Text Domain: eos-rc
Domain Path: /languages/
Version: 0.0.1
*/
/*  This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_action( 'after_setup_theme', 'eos_rc_customize_init' );
//It includes the functionality for responsive check in the customize preview
function eos_rc_customize_init(){
	if( is_customize_preview() ){
		//Definitions
		define( 'EOS_RC_PLUGIN_DIR',untrailingslashit( dirname( __FILE__ ) ) );		
		define( 'EOS_RC_PLUG_URL', untrailingslashit( plugins_url( '', __FILE__ ) ) );
		//It include the PHP functions for the customize previw
		require untrailingslashit( dirname( __FILE__ ) ).'/inc/rc-customize.php';
	}
}

add_filter( 'plugin_action_links_'.untrailingslashit( plugin_basename( __FILE__ ) ), 'eos_rc_plugin_add_settings_link' );
//It adds a settings link to the action links in the plugins page
function eos_rc_plugin_add_settings_link( $links ){
    $settings_link = '<a class="eos-rc-setts" href="'.admin_url( 'customize.php?eos-rc=true' ).'">'. __( 'Check Responsiveness','eos-rc' ). '</a>';
    array_push( $links, $settings_link );
  	return $links;	
}