<?php
/**
 * File required by the main plugin file to register the customize preview functionalities.
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
 
add_filter( 'load_textdomain_mofile', 'eos_rc_load_translation_file',99,2 ); //loads plugin translation files

//It loads plugin translation files
load_plugin_textdomain( 'eos-rc', FALSE,EOS_RC_PLUGIN_DIR . '/languages/' );

 
if( !function_exists( 'eos_customize_register' ) ){
	add_action( 'customize_register', 'eos_customize_register',100 );
	function eos_customize_register( $wp_customize ) {
		$wp_customize->add_section( 
			'eos_tools',
			array(
				'title' => esc_html__( 'Responsiveness check','eos-rc' ),
				'priority' => 99999,
			) 
		);
		$wp_customize->add_setting( 
			'eos_iframe_width',
			array( 
				'sanitize_callback' => 'eos_absint10',
				'transport' => 'postMessage',
			) 
		);
		$wp_customize->add_control( 
			new EOS_device_width_Control( 
				$wp_customize,
				'eos_iframe_width_ctrl', 
				array(
					'settings' => 'eos_iframe_width',
					'section' => 'eos_tools',
					'label' => esc_html__( 'Simulated device css width','eos-rc' ),
				) 
			) 
		);
		$wp_customize->add_setting(
			'eos_iframe_height',
			array( 
				'sanitize_callback' => 'eos_absint10',
				'transport' => 'postMessage',
				'default' => 1200 
			) 
		);
		$wp_customize->add_control( 
			new EOS_device_height_Control(
				$wp_customize,
				'eos_iframe_height_ctrl', 
				array(
					'settings' => 'eos_iframe_height',
					'section' => 'eos_tools',
					'label' => esc_html__( 'Simulated device css height','eos-rc' ),
				) 
			) 
		);
		$wp_customize->add_control( 
			new EOS_device_size_apply_Control(
				$wp_customize,
				'eos_apply_size_ctrl', 
				array(
					'settings' => 'eos_iframe_height',
					'section' => 'eos_tools',
					'label' => esc_html__( 'Apply simulated sizes','eos-rc' ),
				) 
			) 
		);
		$wp_customize->add_setting(
			'eos_width_animation',
			array( 
				'sanitize_callback' => 'eos_absint10',
				'transport' => 'postMessage' 
			) 
		);
		$wp_customize->add_control(
			'eos_width_animation',
			array(
				'type' => 'checkbox',
				'label' => esc_html__( 'Check it to animate the simulated device size between the minimum and maximum width','eos-rc' ),
				'section' => 'eos_tools',
		) );
		$wp_customize->add_setting(
			'eos_iframe_width_min',
			array( 'sanitize_callback' => 'eos_absint10',
				'transport' => 'postMessage',
				'default' => '320' 
			) 
		);
		$wp_customize->add_control( 
			new EOS_numberpx_Control( 
				$wp_customize,'eos_iframe_width_min_ctrl',
				array(
					'settings' => 'eos_iframe_width_min',
					'section' => 'eos_tools',
					'label' => esc_html__( 'Min width','eos-rc' ),
				) 
			) 
		);
		$wp_customize->add_setting( 
			'eos_iframe_width_max',
			array( 'sanitize_callback' => 'eos_absint10',
				'transport' => 'postMessage',
				'default' => '1520' 
			) 
		);
		$wp_customize->add_control( 
			new EOS_numberpx_Control( 
				$wp_customize,'eos_iframe_width_max_ctrl', 
				array(
					'settings' => 'eos_iframe_width_max',
					'section' => 'eos_tools',
					'label' => esc_html__( 'Max width','eos-rc' ),
				) 
			) 
		);
		$wp_customize->add_setting( 
			'eos_grid', 
			array( 
				'sanitize_callback' => 'esc_attr',
				'transport' => 'postMessage',
				'default' => 'none' 
			) 
		);
		$wp_customize->add_control(
			'eos_grid',
			array(
				'type' => 'select',
				'label' => esc_html__( 'Grid','eos-rc' ),
				'section' => 'eos_tools',
				'choices' => array( 'none' => esc_html__( 'None','eos-rc' ),'dark' => esc_html__( 'Dark','eos-rc' ),'light' => esc_html__( 'Light','eos-rc' ) ),
		) );		
		$wp_customize->add_setting( 'eos_common_smartphones', array( 'sanitize_callback' => 'eos_absint10','transport' => 'postMessage' ) );
		$wp_customize->add_control( new EOS_smartphones_sizes_Control( $wp_customize,'eos_smartphone_sizes_ctrl', array(
			'settings' => 'eos_common_smartphones',
			'section' => 'eos_tools',
		) ) );
		$wp_customize->add_setting(
			'eos_common_tablets',
			array( 
				'sanitize_callback' => 'esc_attr',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 
			new EOS_tablets_sizes_Control( 
				$wp_customize,
				'eos_tablet_sizes_ctrl', 
				array(
					'settings' => 'eos_common_tablets',
					'section' => 'eos_tools',
				) 
			) 
		);
		$wp_customize->add_setting( 
			'eos_common_laptops', 
			array( 
				'sanitize_callback' => 'esc_attr',
				'transport' => 'postMessage' 
			) 
		);
		$wp_customize->add_control( 
			new EOS_laptops_sizes_Control( 
				$wp_customize,'eos_laptop_sizes_ctrl', 
				array(
					'settings' => 'eos_common_laptops',
					'section' => 'eos_tools',
				) 
			)
		);
		$wp_customize->add_setting( 
			'eos_full_size', 
			array( 
				'sanitize_callback' => 'esc_attr',
				'transport' => 'postMessage' 
			) 
		);
		$wp_customize->add_control( 
			new EOS_full_sizes_Control( 
				$wp_customize,'eos_full_size_ctrl', 
				array(
					'settings' => 'eos_full_size',
					'section' => 'eos_tools',
					'label' => esc_html__( 'Full size','eos-rc' ),
				) 
			) 
		);
		$wp_customize->add_setting( 
			'eos_invert_ratio', 
			array( 
				'sanitize_callback' => 'esc_attr',
				'transport' => 'postMessage' 
			) 
		);
		$wp_customize->add_control( 
			new EOS_invert_ratio_Control( 
				$wp_customize,'eos_invert_ratio_ctrl', 
				array(
					'settings' => 'eos_invert_ratio',
					'section' => 'eos_tools',
					'label' => esc_html__( 'Invert Orientation','eos-rc' ),
				) 
			) 
		);
	}

	//Input type number control
	class EOS_number_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-control-number"><?php echo esc_html( $this->label ); ?></span>
			<input  type="number" min="0" class="eos-cust-number" <?php $this->link(); ?> />
		</label>
		<?php
		}
	}
	//Input type number control in pixels units
	class EOS_numberpx_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-control-numberpx"><?php echo esc_html( $this->label ); ?></span>
			<input  type="number" min="0" style="max-width:5em;" class="eos-cust-numberpx" <?php $this->link(); ?> /><span>px</span>
		</label>
		<?php
		}
	}
	//Device width control for responsiveness check
	class EOS_device_width_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-control-width"><?php echo esc_html( $this->label ); ?></span>
			<input class="eos-device-width" type="number" style="width:5em;" value="" min="176" max="3000" /><span>px</span>
		</label>
		<?php
		}
	}
	//Device height control for responsiveness check
	class EOS_device_height_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-control-height"><?php echo esc_html( $this->label ); ?></span>
			<input class="eos-device-height" type="number" style="width:5em;" value="" min="200" max="3000" /><span>px</span>
		</label>
		<?php
		}
	}
	//Device size control apply button
	class EOS_device_size_apply_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span id="eos-rc-appy-size" class="button customize-control-size-apply" style="cursor:pointer"><?php echo esc_html( $this->label ); ?></span>
		</label>
		<?php
		}
	}	
	//Smartphones simulation control for responsiveness check
	class EOS_smartphones_sizes_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-control-smartphones"><?php echo esc_html( $this->label ); ?></span>
			<h4><?php _e( 'Common Smartphones','eos-rc' ); ?> <span class="dashicons dashicons-smartphone"></span></h4>
			<select class="eos-common-smartphones">
			<?php foreach( array(
				esc_html__( 'Select ...','eos-rc' ) => array( 0,0 ),
				'Apple iPhone X (375x812)' => array( 375,812 ),
				'Apple iPhone 8 Plus (414x736)' => array( 414,736 ),
				'Apple iPhone 8 (375x667)' => array( 375,667 ),
				'Apple iPhone 7 Plus (414x736)' => array( 414,736 ),
				'Apple iPhone 6s Plus (414x736)' => array( 414,736 ),
				'Apple iPhone 6 Plus (414x736)' => array( 414,736 ),
				'Apple iPhone 7 (375x667)' => array( 375,667 ),
				'Apple iPhone 6s (375x667)' => array( 375,667 ),
				'Apple iPhone 6 (375x667)' => array( 375,667 ),
				'Apple iPhone SE (320x568)' => array( 320,568 ),
				'Apple iPhone 5 (320x568)' => array( 320,568 ),
				'Apple iPhone 4 (320x480)' => array( 320,480 ),
				'Apple iPhone 3 (320x480)' => array( 320,480 ),
				'Apple iPod Touch (320x568)' => array( 320,568 ),
				'LG G4 (360x640)' => array( 360,640 ),
				'LG G3 (360x640)' => array( 360,640 ),
				'LG Optimus G (384x640)' => array( 384,640 ),
				'Samsung Galaxy Note 4 (360x640)' => array( 360,640 ),
				'Samsung Galaxy Note 3 (360x640)' => array( 360,640 ),
				'Samsung Galaxy Note 2 (360x640)' => array( 360,640 ),
				'Samsung Galaxy Note (400x640)' => array( 400,640 ),
				'Samsung Galaxy S5 (360x640)' => array( 360,640 ),
				'Samsung Galaxy S4 (360x640)' => array( 360,640 ),
				'Samsung Galaxy S4 mini (360x640)' => array( 360,640 ),
				'Samsung Galaxy S3 (360x640)' => array( 360,640 ),
				'Samsung Galaxy S3 mini (320x533)' => array( 320,533 ),
				'Samsung Galaxy S2 (320x533)' => array( 320,533 ),
				'Samsung Galaxy S (320x533)' => array( 320,533 ),
				'Samsung Galaxy Nexus (360x600)' => array( 360,600 ),
				'LG Nexus 5 (360x640)' => array( 360,640 ),
				'LG Nexus 4 (384x640)' => array( 384,640 ),
				'Microsoft Lumia 1520 (432x768)' => array( 432,768 ),
				'Microsoft Lumia 1020 (320x480)' => array( 320,480 ),
				'Microsoft Lumia 925 (320x480)' => array( 320,480 ),
				'Microsoft Lumia 920 (320x480)' => array( 320,480 ),
				'Microsoft Lumia 900 (320x480)' => array( 320,480 ),
				'Microsoft Lumia 830 (320x480)' => array( 320,480 ),
				'Microsoft Lumia 620 (320x480)' => array( 320,480 ),
				'Motorola Nexus 6 (412x690)' => array( 412,690 ),
				'HTC One (360x640)' => array( 360,640 ),
				'HTC 8X (320x480)' => array( 320,480 ),
				'HTC Evo 3D (360x640)' => array( 360,640 ),
				'Sony Xperia Z3 (360x598)' => array( 360,598 ),
				'Sony Xperia Z (360x640)' => array( 360,640 ),
				'Sony Xperia S (360x640)' => array( 360,640 ),
				'Sony Xperia P (360x640)' => array( 360,640 ),
				'Xiaomi Mi 4 (360x640)' => array( 360,640 ),
				'Xiaomi Mi 3 (360x640)' => array( 360,640 ),
				'Lenovo K900 (360x640)' => array( 360,640 ),
				'Pantech Vega n 6 (360x640)' => array( 360,640 ),
				'Blackberry Leap (390x695)' => array( 390,695 ),
				'Blackberry Passport (504x504)' => array( 504,504 ),
				'Blackberry Classic (390x390)' => array( 390,390 ),
				'Blackberry Q10 (346x346)' => array( 346,346 ),
				'Blackberry Z30 (360x640)' => array( 360,640 ),
				'Blackberry Z10 (384x640)' => array( 384,640 ),
				'Blackberry Torch 9800 (360x480)' => array( 360,480 ),
				'ZTE Grand S (360x640)' => array( 360,640 ),
				'ZTE Open (Firefox OS) (320x480)' => array( 320,480 ),
			) as $name => $v ){
			?>
				<option value="<?php echo json_encode( $v ); ?>"><?php echo $name; ?></option>
			<?php } ?>
			</select>
		</label>
		<?php
		}
	}
	//Tablet devices simulation control for responsiveness check
	class EOS_tablets_sizes_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-control-tablets"><?php echo esc_html( $this->label ); ?></span>
			<h4><?php _e( 'Common Tablets','eos-rc' ); ?> <span class="dashicons dashicons-tablet"></span></h4>
			<select class="eos-common-tablets">
			<?php foreach( array(
				esc_html__( 'Select ...','eos-rc' ) => array( 0,0 ),
				'Apple iPad Pro 12.9-inch (2nd generation) (1024x1366)' => array( 1024,1366 ),
				'Apple iPad Pro 10.5-inch (1112x834)' => array( 1112,834 ),
				'Apple iPad Pro (12.9-inch) (1024x1366)' => array( 1024,1366 ),
				'Apple iPad Pro (9.7-inch) (768x1024)' => array( 768,1024 ),
				'Apple iPad Air 2 (768x1024)' => array( 768,1024 ),
				'Apple iPad Mini 4 (768x1024)' => array( 768,1024 ),
				'Apple iPad Pro (1024x1366)' => array( 1024,1366 ),
				'Apple iPad 3, 4, Air (768x1024)' => array( 768,1024 ),
				'Apple iPad 1, 2 (768x1024)' => array( 768,1024 ),
				'Apple iPad mini 2, 3 (768x1024)' => array( 768,1024 ),
				'Apple iPad mini (768x1024)' => array( 768,1024 ),
				'Samsung Galaxy Tab 3 10" (800x1280)' => array( 800,1280 ),
				'Samsung Galaxy Tab 2 10" (800x1280)' => array( 800,1280 ),
				'Samsung Galaxy Tab (8.9") (800x1280)' => array( 800,1280 ),
				'Samsung Galaxy Tab 2 (7") (600x1024)' => array( 600,1024 ),
				'Samsung Nexus 10 (800x1280)' => array( 800,1280 ),
				'HTC Nexus 9 (768x1024)' => array( 768,1024 ),
				'Asus Nexus 7 (v2) (600x960)' => array( 600,960 ),
				'Asus Nexus 7 (v1) (604x966)' => array( 604,966 ),
				'LG G Pad 8.3 (600x960)' => array( 600,960 ),
				'Amazon Kindle Fire HD 8.9 (800x1280)' => array( 800,1280 ),
				'Amazon Kindle Fire HD 7 (480x800)' => array( 480,800 ),
				'Amazon Kindle Fire (600x1024)' => array( 600,1024 ),
				'Microsoft Surface Pro 3 (1024x1440)' => array( 1024,1440 ),
				'Microsoft Surface Pro 2 (720x1280)' => array( 720,1280 ),
				'Microsoft Surface Pro (720x1280)' => array( 720,1280 ),
				'Microsoft Surface (768x1366)' => array( 768,1366 ),
				'Blackberry Playbook (600x1024)' => array( 600,1024 ),
			) as $name => $v ){
			?>
				<option value="<?php echo json_encode( $v ); ?>"><?php echo $name; ?></option>
			<?php } ?>
			</select>
		</label>
		<?php
		}
	}
	////Laptop sizes control for responsiveness check
	class EOS_laptops_sizes_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-control-laptops"><?php echo esc_html( $this->label ); ?></span>
			<h4><?php _e( 'Common Laptops','eos-rc' ); ?> <span class="dashicons dashicons-laptop"></span></h4>
			<select class="eos-common-laptops">
			<?php foreach( array(
				esc_html__( 'Select ...','eos-rc' ) => array( 0,0 ),
				'SVGA (800x600)' => array( 800,600 ),
				'XGA (1024x768)' => array( 1024,768 ),
				'WXGA (1440x900)' => array( 1440,900 ),
				'WUXGA (1920x1200)' => array( 1920,1200 ),
				'HD (1366x768)' => array( 1366,768 ),
			) as $name => $v ){
			?>
				<option value="<?php echo json_encode( $v ); ?>"><?php echo $name; ?></option>
			<?php } ?>
			</select>
		</label>
		<?php
		}
	}
	//Full size control to restore the original customize window sizes
	class EOS_full_sizes_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-full-size"><?php echo esc_html( $this->label ); ?></span>
			<button type="button" class="eos-full-size"><span class="dashicons dashicons-editor-expand"></span></button>
		</label>
		<?php
		}
	}
	//Control to toggle the width/height customize window ratio
	class EOS_invert_ratio_Control extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<span class="customize-invert-ratio"><?php echo esc_html( $this->label ); ?></span>
			<button type="button" class="eos-invert-ratio"><span class="dashicons dashicons-image-rotate-right"></span></button>
		</label>
		<?php
		}
	}
	class EOS_separator_for_customizer extends WP_Customize_Control{
		public function render_content(){
		?>
		<label>
			<hr style="margin-top:20px;">
		</label>
		<?php
		}
	}
	//Sanitize 1 digit decimals
	function eos_absint10( $d ){
		return absint( 10*$d )/10;
	}	
	add_action( 'customize_controls_enqueue_scripts', 'eos_rc_enqueue_controls_scripts' );
	//Enqueue scripts needed for customize controls
	function eos_rc_enqueue_controls_scripts(){
		wp_enqueue_script( 'eos-rc-customizer-controls',EOS_RC_PLUG_URL.'/js/rc-customize-controls.js',array( 'jquery' ) );
		if( isset( $_GET['eos-rc'] ) && 'true' === $_GET['eos-rc'] ){
			wp_localize_script( 'eos-rc-customizer-controls','eos_rc_ctrls',array( 'autoload' => true ) );
		}
	}

	add_action( 'customize_preview_init', 'eos_rc_enqueue_customize_preview_scripts' );	
	//It enqueues scripts for the customize
	function eos_rc_enqueue_customize_preview_scripts(){
		wp_enqueue_script( 'eos-rc-customize',EOS_RC_PLUG_URL.'/js/rc-customize.js',array( 'jquery','customize-preview' ),'',true );
	
	}
}

//Filter function to read plugin translation files
function eos_rc_load_translation_file( $mofile, $domain ) {
	if ( 'eos-rc' === $domain ) {
		$loc = function_exists( 'get_user_locale' ) ? get_user_locale() : get_locale();
		$mofile = EOS_RC_PLUGIN_DIR . '/languages/eos-rc-' . $loc . '.mo';
	}
	return $mofile;
}
