<?php 
/**
 * @package  Themeprice Updater
 */
namespace Inc\Pages;

use Inc\Api\SettingsApi;
use Inc\Base\BaseController;
use Inc\Api\Callbacks\AdminCallbacks;

/**
* 
*/
class Admin extends BaseController
{
	public $settings;

	public $callbacks;

	public $pages = array();

	public $subpages = array();

	public function register() 
	{
		$this->settings = new SettingsApi();

		$this->callbacks = new AdminCallbacks();

		$this->setPages();

		$this->setSubpages();

		$this->setSettings();
		$this->setSections();
		$this->setFields();

		$this->settings->addPages( $this->pages )->withSubPage( 'Dashboard' )->addSubPages( $this->subpages )->register();
	}

	public function setPages() 
	{
		$this->pages = array(
			array(
				'page_title' => 'Themeprice Updater',
				'menu_title' => 'Themeprice',
				'capability' => 'manage_options', 
				'menu_slug' => 'themeprice_plugin',
				'callback' => array( $this->callbacks, 'adminDashboard' ),
				'icon_url' => $this->plugin_url.'assets/themeprice-dashicon.png',
				'position' => 100
			)
		);
	}

	public function setSubpages()
	{
		$this->subpages = array(
			array(
				'parent_slug' => 'themeprice_plugin',
				'page_title' => 'Deactivate Plugin', 
				'menu_title' => 'Deactivate', 
				'capability' => 'manage_options', 
				'menu_slug' => 'themeprice_deactive',
				'callback' => array( $this->callbacks, 'adminCpt' )
			),

			array(
				'parent_slug' => 'themeprice_plugin',
				'page_title' => 'Update Check',
				'menu_title' => 'Update Check',
				'capability' => 'manage_options', 
				'menu_slug' => 'themeprice_update_check',
				'callback' => array( $this->callbacks, 'manualupdate' )
			),
		);
	}

	public function setSettings()
	{
		$args = array(
			array(
				'option_group' => 'themeprice_options_group',
				'option_name' => 'themepriceusername',
				'callback' => array( $this->callbacks, 'themepriceOptionsGroup' )
			),
			array(
				'option_group' => 'themeprice_options_group',
				'option_name' => 'themepricepassword'
			)
		);

		$this->settings->setSettings( $args );
	}

	public function setSections()
	{
		$args = array(
			array(
				'id' => 'themeprice_admin_index',
				'title' => '',
				'callback' => array( $this->callbacks, 'themepriceAdminSection' ),
				'page' => 'themeprice_plugin'
			)
		);

		$this->settings->setSections( $args );
	}

	public function setFields()
	{
		$args = array(
			array(
				'id' => 'themepriceusername',
				'title' => 'User Name / Email',
				'callback' => array( $this->callbacks, 'themepriceusername' ),
				'page' => 'themeprice_plugin',
				'section' => 'themeprice_admin_index',
				'args' => array(
					'label_for' => 'themepriceusername',
					'class' => 'themeprice-class'
				)
			),
			array(
				'id' => 'themepricepassword',
				'title' => 'themepricepassword',
				'callback' => array( $this->callbacks, 'themepricepassword' ),
				'page' => 'themeprice_plugin',
				'section' => 'themeprice_admin_index',
				'args' => array(
					'label_for' => 'themepricepassword',
					'class' => 'themeprice-class'
					)
				),
			array(
				'id' => 'themepricestatus',
				'title' => 'Status',
				'callback' => array( $this->callbacks, 'themepricesubscription' ),
				'page' => 'themeprice_plugin',
				'section' => 'themeprice_admin_index',
				'args' => array(
					'label_for' => 'themepricestatus',
					'class' => 'themepricemystatus'
				)
			),	

		);

		$this->settings->setFields( $args );
	}
}