<?php
/**
 * @package  Themeprice Updater
 */
/*
Plugin Name: Themeprice Updater
Plugin URI: https://themeprice.com/
Description: Themeprice Updater
Version: 1.0.28
Author: Themeprice
Author URI: https://themeprice.com/
License: GPLv2 or later
Text Domain: themeprice
*/



defined( 'ABSPATH' ) or die( 'Do not do this' );

// Require once the Composer Autoload
if ( file_exists( dirname( __FILE__ ) . '/vendor/autoload.php' ) ) {
	require_once dirname( __FILE__ ) . '/vendor/autoload.php';
}

/**
 * The code that runs during plugin activation
 */
function activate_themeprice_plugin() {
	ob_start();
	Inc\Base\Activate::activate();
	$current_time = date('H:i:s');
	$endTime = strtotime("+59 minutes", strtotime($current_time));
	$finaltime = date('H:i:s', $endTime);
	$themepriceplugslug = [];
	$themepricediffslug = [];

	update_option( 'themepriceupdaterstatus', $finaltime, true );
	update_option( 'themepricepluginlistslug', $themepriceplugslug, true );
	update_option( 'themepricediffslug', $themepricediffslug, true );
	flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'activate_themeprice_plugin');

/**
 * The code that runs during plugin deactivation
 */
function deactivate_themeprice_plugin() {
	Inc\Base\Deactivate::deactivate();
}
register_deactivation_hook( __FILE__, 'deactivate_themeprice_plugin');

/**
 * Initialize all the core classes of the plugin
 */
if ( class_exists( 'Inc\\Init' ) ) {
	
	Inc\Init::register_services();
	
}


function filter_plugin_updates( $value ) {
	$result_slug = get_option( 'themepricediffslug' );

	if ($result_slug != NULL) {
	foreach ($result_slug as $plugin) {
		if ( isset( $value->response[$plugin] ) ) {

				unset( $value->response[$plugin] );
			}
		}
	}
	   
	return $value;
}


